package gov.va.med.mhv.bluebutton.bbmi.imaging.util;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

import org.dcm4che3.image.BufferedImageUtils;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;

public class ConvertDCMToJPEG {

	private int frame = 0;
	private final ImageReader imageReader = (ImageReader) ImageIO.getImageReadersByFormatName("DICOM").next();

	private ImageWriter imageWriter;
	private ImageWriteParam imageWriteParam;

	public ConvertDCMToJPEG(Number quality) {
		initImageWriter("JPEG", null, null, null, quality);
	}

	public void convert(InputStream src, OutputStream dest) throws IOException {
		ImageInputStream iis = ImageIO.createImageInputStream(src);
		try {
			BufferedImage bi = readImage(iis);
			bi = convert(bi);
			ImageOutputStream ios = ImageIO.createImageOutputStream(dest);
			writeImage(ios, bi);
			ios.flush();
			
			return;
		} catch(Exception e) {
			throw new IOException(e);
		} finally {
			try {
				iis.close();
			} catch (IOException ignore) {
				ignore.printStackTrace();
			}
		}
	}

	private BufferedImage convert(BufferedImage bi) {
		ColorModel cm = bi.getColorModel();
		return cm.getNumComponents() == 3 ? BufferedImageUtils.convertToIntRGB(bi) : bi;
	}

	private BufferedImage readImage(ImageInputStream iis) throws IOException {
		imageReader.setInput(iis);
		return imageReader.read(frame, readParam());
	}

	private void writeImage(ImageOutputStream ios, BufferedImage bi) throws IOException {
		imageWriter.setOutput(ios);
		imageWriter.write(null, new IIOImage(bi, null, null), imageWriteParam);
	}

	public void initImageWriter(String formatName, String suffix, String clazz, String compressionType, Number quality) {
		Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(formatName);

		if (!imageWriters.hasNext()) {
			throw new IllegalArgumentException("FormatNotSupported");
		}

		imageWriter = ((ImageWriter) imageWriters.next());
		if (clazz != null) {
			while (!clazz.equals(imageWriter.getClass().getName())) {
				if (imageWriters.hasNext()) {
					imageWriter = ((ImageWriter) imageWriters.next());
					System.out.println(imageWriter);
				} else
					throw new IllegalArgumentException("No such image Writer");
			}
		}
		imageWriteParam = imageWriter.getDefaultWriteParam();
		if ((compressionType != null) || (quality != null)) {
			imageWriteParam.setCompressionMode(2);
			if (compressionType != null)
				imageWriteParam.setCompressionType(compressionType);
			if (quality != null)
				imageWriteParam.setCompressionQuality(quality.floatValue());
		}
	}
	
	private ImageReadParam readParam() {
        DicomImageReadParam param = (DicomImageReadParam) imageReader.getDefaultReadParam();
        param.setWindowCenter(0.0f);
        param.setWindowWidth(0.0f);
        param.setAutoWindowing(true);
        param.setWindowIndex(0);
        param.setVOILUTIndex(0);
        param.setPreferWindow(true);
        param.setPresentationState(null);
        param.setOverlayActivationMask(65535);
        param.setOverlayGrayscaleValue(65535);
        return param;
    }

//	public static void main(String arg[]) {
//		try {
//			File folder = new File("/tmp/tmp/DICOM/SERIES_1");
//			File[] listOfFiles = folder.listFiles();
//			ConvertDCMToJPEG cnv = new ConvertDCMToJPEG(.30f);
//			  for (int i = 0; i < listOfFiles.length; i++) {
//			    if (listOfFiles[i].isFile() && listOfFiles[i].getName().endsWith(".dcm")) {
//			      System.out.println("File " + listOfFiles[i].getName());
//			      
//			      File out = new File( (listOfFiles[i].getAbsolutePath()+"-auto.jpg").replace(".dcm", ""));
//			      System.out.println(out);
//			      cnv.convert(new FileInputStream(listOfFiles[i]), new FileOutputStream(out));
//			    }
//			  }
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//	}
	
	public static void main(String ar[]) {
			ConvertDCMToJPEG c = new ConvertDCMToJPEG(.30f);

			try {
				File s = new File(".");
				System.out.println(s.getAbsolutePath());
				
				FileInputStream src = new FileInputStream("7578.dcm");
				System.out.println(src.available());
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				
				c.convert(src, baos);
				
				System.out.println(baos.size());
				BufferedImage i = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
				System.out.println(i);

			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}
	
	
}
